function regulafalsiplotter(f,xu,xo,epsilon,xneu,x)
% plotter for regulafalsibackend.m

% (c) Dennis G. <bluedrago@gmx.de> 2007 - see file COPYING for details


if nargin ~= 6,
	error('Please don''t start this directly, use regulafalsi.m\n Bitte rufen Sie dieses Programm nicht direkt auf, nutzen sie regulafalsi.m');
end

	dx = xo-xu;
	dy = f(xo)-f(xu);

	% Intervall der angezeigt werden soll bestimmen,
	% nötig, so dass immer das volle Schaubild angezeit wird
	% axis() nicht richtig nutzbar da dies auf Kosten der
	% Darstellungsgenauigkeit geht
		if xu-epsilon < min(x),
			x=linspace(xu-epsilon,max(x),500);
		end
		if xo+epsilon > max(x),
			x=linspace(min(x),xo+epsilon,500);
		end
		if xneu > max(x),
			x=linspace(min(x),xneu+epsilon,500);
		end
		if xneu < min(x),
			x=linspace(xneu-epsilon,max(x),500);
		end

	% Schleife um das ganze in zwei Plots parallel
	% darzustellen
	for i=1:2,
	%	Auswahl des ersten oder zweiten Subplots
		subplot(1, 2, i);
	%	hold off, um die vorigen Schaubilder nicht beizubehalten
		hold off;
	% - die Funktion, jenachdem ob plot 1 oder 2:
		if i==1,
			plot(x,f(x),'b');
		else
			% soll reingezoomt sein, Eingrenzung des Bereichs:
			xi=linspace(xu-epsilon,xo+epsilon,500);
			% sichergehen, dass das Schaubild bis xneu geplottet wird:
			if xneu > max(xi),
				xi=linspace(min(xi),xneu+epsilon,500);
			end
			if xneu < min(xi),
				xi=linspace(xneu-epsilon,max(xi),500);
			end
			% plotten:
			plot(xi,f(xi),'b');
		end
	%   gitterlinien, und hold für weitere plots:
	grid on;
	hold on;
	% - Sekantengerade nach m*x+c:
	%   y-Achsenverschiebung
	c=f(xu)-(dy/dx)*xu;
	%   plotten der Sekante, je nach subplot:
		if i==1,
			plot(x,(dy/dx)*x+c,'r');
			% zurücksetzen der Achsen, um ein fixes Bild zu gewährleisten (0.2 Toleranz)
			axis([min(x) max(x) min(f(x)-0.2) max(f(x)+0.2)]);
		else
			% Bereich wurde bereits zuvor beim plotten der Funktion richtig eingegrenzt,
			% hier nicht mehr notwendig
			plot(xi,(dy/dx)*xi+c,'r');

			% wähle optimalen Bereich, Sekanten ziehen leider das Bild manchmal sehr groß
			% deswegen wird hier nur auf die Funktion fixiert (mit 0.2 Toleranz)
			% die Sekante des nächsten Schrittes kann hier nicht berücksichtigt werden
			% oder es wird insgesamt komplexer
			axis([min(xi) max(xi) min(f(xi)-0.2) max(f(xi)+0.2)]);

			%   Sekante des nächsten Schrittes (nur im detaillierten Plot):

			xtemp=xu-(dx/dy)*f(xu);
			if f(xtemp)*f(xu) > 0,
				dx=xo-xtemp;
				dy=f(xo)-f(xtemp);
				plot(xi,(dy/dx)*xi+f(xtemp)-(dy/dx)*xtemp,'g');
			elseif f(xtemp)*f(xu) < 0,
				dx=xtemp-xu;
				dy=f(xtemp)-f(xu);
				plot(xi,(dy/dx)*xi+f(xu)-(dy/dx)*xu,'g');
			end
		end

	%   neuer x-Punkt auf der x-Achse - zur Veranschaulichung
	plot(xneu,0,'ob','markersize',1.5);
	% - Grenzpunkte: (0.000000000000001 um ein fehler von gnuplot-4.2.2 zu umgehen)
	plot(xo-0.000000000000001,f(xo),'pr','markersize',1.5);
	plot(xu+0.000000000000001,f(xu),'pr','markersize',1.5);

	%   neuer Wert in schwarz:
	plot(xneu,f(xneu),'hk','markersize',1.5);
	end
	% sleep, um es nachvollziehen zu können
	disp('pause - press return/ druecken Sie Enter');
	pause;

end