function [xu, xo] = regulafalsiguess(f,start)
% calculates an interval to use with regulafalsi,
% if no or just one value for the interval was specified
% errechnet einen interval zur Benutzung mit regulafalsi,
% falls kein oder nur ein Intervallwert angegeben wurde
% [xu, xo] = regulafalsiguess(f,start)
% [xu, xo] = regulafalsiguess(f)

% (c) Dennis G. <bluedrago@gmx.de> 2007 - see file COPYING for details

if nargin ~= 1 && nargin ~= 2,
	error('Wrong number of Arguments / Falsche Anzahl an Eingangswerten');
elseif nargin == 1,
	xu=-1;
	xo=1;
elseif nargin == 2,
	xu=start-1;
	xo=start+1;
end

% as long as the y-values have the same prefix and not more than 100 steps long
% rechne solange die y-Werte das selbe Vorzeichen haben und nicht schon mehr als
% 100 mal gerechnet wurde
i=0;
while f(xu)*f(xo) > 0 && i < 100,
	xu=xu-1;
	xo=xo+1;
	i=i+1;
end
xu;
xo;