function xneu = regulafalsibackend(f,xu,xo,epsilon,g)
% backend for the regulafalsi.m script
% / Funktion die von regulafalsi.m verwendet wird
% please use regulafalsi.m
% / bitte nutzen sie regulafalsi.m
%
% read/lesen Sie: help regulafalsi

% (c) Dennis G. <bluedrago@gmx.de> 2007 - see file COPYING for details

if nargin ~= 4 && nargin ~= 5,
	error('Wrong number of Arguments / Falsche Anzahl an Eingangswerten');

% immer dann plotten, solange das 5te Argument auf 'egal was' gesetzt ist - also existiert
elseif nargin == 5,
	% Grenzintervall in Epsilonschritten, notwendig für spätere grafische Darstellung
	x=linspace(xu-epsilon,xo+epsilon,500);
	% setzen des ersten subplots
	subplot(1, 2, 1);
end

% xneu zu Anfang auf xu oder xo setzen (hier xu),
% so dass ein Vergleichswert vorhanden ist
xneu=xu;

% rechnen bis der y-wert des ergebnises so nahe wie epsilon an 0 ist
% also auf eine Genauigkeit der Nachkommastellen wie epsilon sie besitzt
while abs(f(xneu)) > epsilon,

        % Überprüfe ob f(xu) Vorzeichen gleich oder ungleich
        % dem neu berechneten f(xneu) ist
        % und setze die neuen Grenzen entsprechend
	% so dass die Sekante immernoch die x-Achse schneidet

	% wenn Vorzeichen gleich
        if f(xu)*f(xneu) > 0,
                xu=xneu;
	% wenn Vorzeichen ungleich
        elseif f(xu)*f(xneu) < 0,
                xo=xneu;
        end

        % differenz von xu und xo:
        dx = xo-xu;
        % differenz von funktionswerten von xu und xo:
        dy = f(xo)-f(xu);

        % neuer x-Wert, für einen der nächsten Punkte der Sekante
        xneu=xu-(dx/dy)*f(xu);

	if nargin == 5,
		regulafalsiplotter(f,xu,xo,epsilon,xneu,x);
	end

end

end