function [xneu,fxneu] = regulafalsi(f,xu,xo,epsilon,g)
% Regula Falsi / method of linear interpolation / secant method
% Verfahren der linearen Interpolation / Sekantenverfahren
% an iterative method to calculate the root of a function
% ein iteratives Verfahren um die Nullstellen einer Funktion zu finden
%
% INPUT / EINGABE:
% regulafalsi(f,xu,xo,epsilon,graphical?)
%
% ARG 1:
% f can be a predefined function, e.g.: / f kann eine vordefinierte Funktion sein, z.B.:
% f = f(x) = x.^2-2
%
% ARG 2 & 3:
% xu = lower limit of the interval / untere Intervallgrenze
%      or start from where the interval is calculated, if xo is not given
%      / oder Ausgangspunkt für welchen ein Intervall errechnet wird, wenn xo nicht gegeben
% xo = upper limit of the interval / obere Intervallgrenze
% ARG 4:
% epsilon = accuracy / Genauigkeit = e.g./z.B.: 0.1
%         will be set to 0.01 if not given / wird auf 0.01 gesetzt, wenn nicht angegeben
% ARG 5:
% if it is set to either value, plotting will be done, and you have to
% confirm every step by pressing any key on the octave terminal
% / wenn es auf egal was gesetzt ist, wird geplottet, und man muss jeden Schritt auf der
% Eingabezeile bestätigen
%
% OUTPUT / AUSGABE:
% [x0, f(x0)]

% (c) Dennis G. <bluedrago@gmx.de> 2007 - see file COPYING for details


% wrapper around regulafalsibackend and regulafalsiguess

if nargin < 1,
	error('You need to input parameters / Sie müssen Parameter übergeben\n')
elseif nargin < 2,
	fprintf('Guesstimating interval / "Erahnen" des Intervalls\n')
	[xu, xo] = regulafalsiguess(f);
elseif nargin < 3,
	fprintf('Calculating interval from %.3f / Erechnen des Intervals ausgehend von %.3f\n',xu,xu)
	[xu, xo] = regulafalsiguess(f,xu);
end
if nargin < 4,
	epsilon = 0.01;
	fprintf('Using default epsilon %.2f\n', epsilon)
end

if nargin == 5,
	xneu = regulafalsibackend(f,xu,xo,epsilon,g);
else
	xneu = regulafalsibackend(f,xu,xo,epsilon);
end

fxneu=f(xneu);